% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RANN-package.R
\docType{package}
\name{RANN-package}
\alias{RANN-package}
\alias{RANN}
\title{Wrapper for Arya and Mount's Approximate Nearest Neighbours (ANN) C++ library}
\description{
Finds the k nearest neighbours for every point in a given dataset in O(N log N) time using Arya and Mount's ANN library (v1.1.3). There is support for approximate as well as exact searches, fixed radius searches and 'bd' as well as 'kd' trees. The distance is computed using the L2 (Euclidean) metric. Please see package 'RANN.L1' for the same functionality using the L1 (Manhattan, taxicab) metric.
}
\seealso{
\code{\link{nn2}}
}
\author{
\strong{Maintainer}: Gregory Jefferis \email{jefferis@gmail.com} (\href{https://orcid.org/0000-0002-0587-9355}{ORCID})

Authors:
\itemize{
  \item Samuel E. Kemp
  \item Sunil Arya (\href{https://orcid.org/0000-0003-0939-4192}{ORCID}) [copyright holder]
  \item David Mount (\href{https://orcid.org/0000-0002-3290-8932}{ORCID}) [copyright holder]
}

Other contributors:
\itemize{
  \item Kirill Müller (\href{https://orcid.org/0000-0002-1416-3412}{ORCID}) [contributor]
  \item University of Maryland (ANN library is copyright University of Maryland and Sunil Arya and David Mount. See file COPYRIGHT for details) [copyright holder]
}

}
\keyword{package}
