% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{has_testing_data}
\alias{has_testing_data}
\title{Check if the results object generated by irace has data about the testing phase.}
\usage{
has_testing_data(iraceResults)
}
\arguments{
\item{iraceResults}{\code{list()}|\code{character(1)}\cr Object created by \pkg{irace} and typically saved in the log file \code{irace.Rdata}. If a character string is given, then it is interpreted as the path to the log file from which the \code{iraceResults} object will be loaded.}
}
\value{
\code{logical(1)}
}
\description{
Check if the results object generated by irace has data about the testing phase.
}
\examples{
irace_results <- read_logfile(system.file("exdata/irace-acotsp.Rdata", package="irace",
                                          mustWork=TRUE))
print(has_testing_data(irace_results))
}
