% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_df.R
\name{get_df}
\alias{get_df}
\alias{get_df.default}
\title{Extract degrees of freedom}
\usage{
get_df(x, ...)

\method{get_df}{default}(x, type = "residual", verbose = TRUE, ...)
}
\arguments{
\item{x}{A statistical model.}

\item{...}{Currently not used.}

\item{type}{Can be \code{"residual"} or \code{"model"}. \code{"residual"}
tries to extract residual degrees of freedoms. If residual degrees of freedom
could not be extracted, returns \code{n-k} (number of observations minus
number of parameters). \code{"model"} returns model-based degrees of freedom,
i.e. the number of (estimated) parameters.}

\item{verbose}{Toggle warnings.}
}
\description{
Estimate or extract residual or model-based degrees of freedom from regression models.
}
\examples{
model <- lm(Sepal.Length ~ Petal.Length * Species, data = iris)
get_df(model) # same as df.residual(model)
get_df(model, type = "model") # same as attr(logLik(model), "df")
}
