% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSizeSimulation.R
\name{precision.simulation}
\alias{precision.simulation}
\alias{precision.simulation.exact}
\alias{precision.simulation.coarse}
\alias{generate.coarse.data}
\title{Simulate incubation period analyses with coarse data}
\usage{
precision.simulation(
  N,
  med = 2,
  disp = 1.3,
  percentile = 0.5,
  nsim = 100,
  exact.data = FALSE,
  pct.type.A = 0.5,
  exp.win.dat = NULL,
  verb = FALSE
)

precision.simulation.exact(N, med, disp, percentile, nsim, verb)

precision.simulation.coarse(
  N,
  med,
  disp,
  percentile,
  nsim,
  pct.type.A,
  exp.win.dat,
  verb
)

generate.coarse.data(N, med, disp, pct.type.A, exp.win.dat)
}
\arguments{
\item{N}{Overall sample size for the datasets to be simulated.}

\item{med}{Median for the assumed log normal distribution of the incubation
periods.}

\item{disp}{Dispersion for the assumed log normal distribution of the
incubation periods.}

\item{percentile}{Percentile of the incubation period distribution which we
want to estimate.}

\item{nsim}{Number of datasets to analyze in the simulation.}

\item{exact.data}{Either TRUE/FALSE.  Incidates whether the data generated
should be coarsened at all.  If TRUE, pct.type.A and exp.win.dat are
ignored.}

\item{pct.type.A}{Percent of the N observations that are assumed to be type
A data.  If N*pct.type.A is not an integer, it will be rounded to the
nearest integer.}

\item{exp.win.dat}{A vector of exposure window lengths.  Defaults to the
observed window lengths from Lessler et al. (see below).}

\item{verb}{If TRUE, a message with the system time and iteration number
will be printed ten times during the simulation run.}
}
\value{
The \code{precision.simulation} functions return a matrix with four
  columns and nsim rows.  The "ests" column gives the estimated percentiles
  for the incubation period distribution.  The "SE" column gives the
  standard error for the estimate.  The "conv" column is 1 if the doubly
  interval-censored likelihood maximization converged.  Otherwise, it is 0.
  The "bias" column gives the estimated percentile - true percentile. The
  \code{generate.coarse.data} function returns a matrix with data suitable
  for analysis by the \code{dic.fit} function.
}
\description{
These functions simulate coarse incubation period data sets and
  analyze them.  The goal is for these simulations to provide evidence for
  how much information a given dataset contains about a characteristic of
  the incubation period distribution.
}
