% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date_build}
\alias{date_build}
\title{Building: date}
\usage{
date_build(year, month = 1L, day = 1L, ..., invalid = NULL)
}
\arguments{
\item{year}{\verb{[integer]}

The year. Values \verb{[-32767, 32767]} are generally allowed.}

\item{month}{\verb{[integer]}

The month. Values \verb{[1, 12]} are allowed.}

\item{day}{\verb{[integer / "last"]}

The day of the month. Values \verb{[1, 31]} are allowed.

If \code{"last"}, then the last day of the month is returned.}

\item{...}{These dots are for future extensions and must be empty.}

\item{invalid}{\verb{[character(1) / NULL]}

One of the following invalid date resolution strategies:
\itemize{
\item \code{"previous"}: The previous valid instant in time.
\item \code{"previous-day"}: The previous valid day in time, keeping the time of
day.
\item \code{"next"}: The next valid instant in time.
\item \code{"next-day"}: The next valid day in time, keeping the time of day.
\item \code{"overflow"}: Overflow by the number of days that the input is invalid
by. Time of day is dropped.
\item \code{"overflow-day"}: Overflow by the number of days that the input is
invalid by. Time of day is kept.
\item \code{"NA"}: Replace invalid dates with \code{NA}.
\item \code{"error"}: Error on invalid dates.
}

Using either \code{"previous"} or \code{"next"} is generally recommended, as these
two strategies maintain the \emph{relative ordering} between elements of the
input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{invalid} must be supplied and
cannot be \code{NULL}. This is a convenient way to make production code robust
to invalid dates.}
}
\value{
A Date.
}
\description{
\code{date_build()} builds a Date from it's individual components.
}
\details{
Components are recycled against each other.
}
\examples{
date_build(2019)
date_build(2019, 1:3)

# Generating invalid dates will trigger an error
try(date_build(2019, 1:12, 31))

# You can resolve this with `invalid`
date_build(2019, 1:12, 31, invalid = "previous")

# But this particular case (the last day of the month) is better
# specified as:
date_build(2019, 1:12, "last")
}
