% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{pairs.brmsfit}
\alias{pairs.brmsfit}
\title{Create a matrix of output plots from a \code{brmsfit} object}
\usage{
\method{pairs}{brmsfit}(x, pars = NA, fixed = FALSE, exact_match = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{brmsfit}}

\item{pars}{Names of the parameters to plot, as given by a character vector 
or a regular expression. By default, all parameters except 
for group-level and smooth effects are plotted.}

\item{fixed}{Indicates whether parameter names 
should be matched exactly (\code{TRUE}) or treated as
regular expressions (\code{FALSE}). Default is \code{FALSE}.}

\item{exact_match}{Deprecated alias of argument \code{fixed}.}

\item{...}{Further arguments to be passed to 
\code{\link[bayesplot:MCMC-scatterplots]{mcmc_pairs}}.}
}
\description{
A \code{\link[graphics:pairs]{pairs}} 
method that is customized for MCMC output.
}
\details{
For a detailed description see  
  \code{\link[bayesplot:MCMC-scatterplots]{mcmc_pairs}}.
}
\examples{
\dontrun{
fit <- brm(count ~ zAge + zBase * Trt 
           + (1|patient) + (1|visit), 
           data = epilepsy, family = "poisson")  
pairs(fit, pars = parnames(fit)[1:3], fixed = TRUE)
pairs(fit, pars = "^sd_")
}

}
