% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal_superiority.R
\name{ordinal_superiority.bracl}
\alias{ordinal_superiority.bracl}
\alias{ordinal_superiority}
\title{Ordinal superiority scores of Agresti and Kateri (2017)}
\usage{
\method{ordinal_superiority}{bracl}(
  object,
  formula,
  data,
  measure = c("gamma", "Delta"),
  level = 0.95,
  bc = FALSE
)
}
\arguments{
\item{object}{a fitted object from an ordinal regression
model. Currently only models from class \code{\link[=bracl]{"bracl"}} are supported.}

\item{formula}{a RHS formula indicating the group variable to use.}

\item{data}{an optional data frame in which to look for variables
with which to compute ordinal superiority measures.  If
omitted, an attempt is made to use the data that produced
\code{object}.}

\item{measure}{either \code{"gamma"} (default) or \code{"Delta"}, specifying
the ordinal superiority measure to be returned.}

\item{level}{the confidence level required when computing
confidence intervals for the ordinal superiority measures.}

\item{bc}{logical. If \code{FALSE} (default) then the ordinal
superiority measures are computed using the estimates in
\code{object}. If \code{TRUE} then the ordinal superiority measure
estimates are corrected for mean bias.}
}
\description{
\code{\link[=ordinal_superiority]{ordinal_superiority()}} is a method for the estimation and
inference about model-based ordinal superiority scores introduced
in Agresti and Kateri (2017, Section 5) from fitted objects. The
mean bias of the estimates of the ordinal superiority scores can be
corrected.
}
\examples{

data("stemcell", package = "brglm2")

# Adjacent category logit (proportional odds)
stem <- within(stemcell, {nreligion = as.numeric(religion)})
fit_bracl_p <- bracl(research ~ nreligion + gender, weights = frequency,
                     data = stem, type = "ML", parallel = TRUE)

# Estimates and 95\% confidence intervals for the probabilities that the response
# category for gender "female" is higher than the response category for gender "male",
# while adjusting for religion.
ordinal_superiority(fit_bracl_p, ~ gender)

\dontrun{
# And their (very-similar in value here) bias corrected versions
# with 99\% CIs
ordinal_superiority(fit_bracl_p, ~ gender, bc = TRUE, level = 0.99)
# Note that the object is refitted with type = "AS_mean"

}

}
\references{
Agresti, A., Kateri, M. (2017). Ordinal probability effect measures
for group comparisons in multinomial cumulative link models.
\emph{Biometrics}, \strong{73} 214-219. \doi{10.1111/biom.12565}.
}
