% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.R
\name{with.amelia}
\alias{with.amelia}
\title{Execute commands within each imputed data set}
\usage{
\method{with}{amelia}(data, expr, ...)
}
\arguments{
\item{data}{imputation output from the \code{amelia} funtion.}

\item{expr}{expression to evaluate in each imputed data set in
\code{data}.}

\item{...}{arguments to be passed to (future) methods.}
}
\value{
a list the same length as \code{data$imputations} that
contains the output of the expression as evaluated in each imputed
data set of \code{data}.
}
\description{
Evaluate an R expression in the environments constructed from the
imputed data sets of a call to \code{amelia} function.
}
\examples{
data(africa)
a.out <- amelia(x = africa, cs = "country", ts = "year", logs =
"gdp_pc")

imp.mods <- with(a.out, lm(gdp_pc ~ infl + trade))

mi.combine(imp.mods, conf.int = TRUE)

}
\author{
Matt Blackwell
}
