% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{labelKeep}
\alias{labelKeep}
\title{Label rows to keep based on minimal count}
\usage{
labelKeep(y, minCount = 10, minN = 3, x)
}
\arguments{
\item{y}{a SummarizedExperiment}

\item{minCount}{the minimum count}

\item{minN}{the minimum sample size at \code{minCount}}

\item{x}{the name of the condition variable, will
use the smaller of the two groups to set \code{minN}.
Similar to edgeR's \code{filterByExpr}, as the smaller group
grows past 10, \code{minN} grows only by 0.7 increments
of sample size}
}
\value{
a SummarizedExperiment with a new column \code{keep}
in \code{mcols(y)}
}
\description{
Adds a column \code{keep} to \code{mcols(y)} that specifies
which rows of the SummarizedExperiment will be included
in statistical testing. Rows are not removed, just marked
with the logical \code{keep}.
}
\examples{

y <- makeSimSwishData()
y <- scaleInfReps(y)
y <- labelKeep(y)

}
