# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AdvancedFilter(msrest.serialization.Model):
    """This is the base type that represents an advanced filter. To configure an advanced filter, do not directly instantiate an object of this class. Instead, instantiate an object of a derived class such as BoolEqualsAdvancedFilter, NumberInAdvancedFilter, StringEqualsAdvancedFilter etc. depending on the type of the key based on which you want to filter.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BoolEqualsAdvancedFilter, NumberGreaterThanAdvancedFilter, NumberGreaterThanOrEqualsAdvancedFilter, NumberInAdvancedFilter, NumberLessThanAdvancedFilter, NumberLessThanOrEqualsAdvancedFilter, NumberNotInAdvancedFilter, StringBeginsWithAdvancedFilter, StringContainsAdvancedFilter, StringEndsWithAdvancedFilter, StringInAdvancedFilter, StringNotInAdvancedFilter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    _subtype_map = {
        'operator_type': {'BoolEquals': 'BoolEqualsAdvancedFilter', 'NumberGreaterThan': 'NumberGreaterThanAdvancedFilter', 'NumberGreaterThanOrEquals': 'NumberGreaterThanOrEqualsAdvancedFilter', 'NumberIn': 'NumberInAdvancedFilter', 'NumberLessThan': 'NumberLessThanAdvancedFilter', 'NumberLessThanOrEquals': 'NumberLessThanOrEqualsAdvancedFilter', 'NumberNotIn': 'NumberNotInAdvancedFilter', 'StringBeginsWith': 'StringBeginsWithAdvancedFilter', 'StringContains': 'StringContainsAdvancedFilter', 'StringEndsWith': 'StringEndsWithAdvancedFilter', 'StringIn': 'StringInAdvancedFilter', 'StringNotIn': 'StringNotInAdvancedFilter'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdvancedFilter, self).__init__(**kwargs)
        self.operator_type = None  # type: Optional[str]
        self.key = kwargs.get('key', None)


class EventSubscriptionDestination(msrest.serialization.Model):
    """Information about the destination for an event subscription.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFunctionEventSubscriptionDestination, EventHubEventSubscriptionDestination, HybridConnectionEventSubscriptionDestination, ServiceBusQueueEventSubscriptionDestination, ServiceBusTopicEventSubscriptionDestination, StorageQueueEventSubscriptionDestination, WebHookEventSubscriptionDestination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'AzureFunction': 'AzureFunctionEventSubscriptionDestination', 'EventHub': 'EventHubEventSubscriptionDestination', 'HybridConnection': 'HybridConnectionEventSubscriptionDestination', 'ServiceBusQueue': 'ServiceBusQueueEventSubscriptionDestination', 'ServiceBusTopic': 'ServiceBusTopicEventSubscriptionDestination', 'StorageQueue': 'StorageQueueEventSubscriptionDestination', 'WebHook': 'WebHookEventSubscriptionDestination'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = None  # type: Optional[str]


class AzureFunctionEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the azure function destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of the Azure Function
     destination of an event subscription.
    :type resource_id: str
    :param max_events_per_batch: Maximum number of events per batch.
    :type max_events_per_batch: int
    :param preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
    :type preferred_batch_size_in_kilobytes: int
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'max_events_per_batch': {'key': 'properties.maxEventsPerBatch', 'type': 'int'},
        'preferred_batch_size_in_kilobytes': {'key': 'properties.preferredBatchSizeInKilobytes', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFunctionEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'AzureFunction'  # type: str
        self.resource_id = kwargs.get('resource_id', None)
        self.max_events_per_batch = kwargs.get('max_events_per_batch', None)
        self.preferred_batch_size_in_kilobytes = kwargs.get('preferred_batch_size_in_kilobytes', None)


class BoolEqualsAdvancedFilter(AdvancedFilter):
    """BoolEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The boolean filter value.
    :type value: bool
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BoolEqualsAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'BoolEquals'  # type: str
        self.value = kwargs.get('value', None)


class ConnectionState(msrest.serialization.Model):
    """ConnectionState information.

    :param status: Status of the connection. Possible values include: "Pending", "Approved",
     "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.eventgrid.models.PersistedConnectionStatus
    :param description: Description of the connection state.
    :type description: str
    :param actions_required: Actions required (if any).
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class DeadLetterDestination(msrest.serialization.Model):
    """Information about the dead letter destination for an event subscription. To configure a deadletter destination, do not directly instantiate an object of this class. Instead, instantiate an object of a derived class. Currently, StorageBlobDeadLetterDestination is the only class that derives from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StorageBlobDeadLetterDestination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the dead letter destination.Constant
     filled by server.  Possible values include: "StorageBlob".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.DeadLetterEndPointType
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'StorageBlob': 'StorageBlobDeadLetterDestination'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeadLetterDestination, self).__init__(**kwargs)
        self.endpoint_type = None  # type: Optional[str]


class Resource(msrest.serialization.Model):
    """Definition of a Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """Definition of a Tracked Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class Domain(TrackedResource):
    """EventGrid Domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param private_endpoint_connections: List of private endpoint connections.
    :type private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the domain. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.DomainProvisioningState
    :ivar endpoint: Endpoint for the domain.
    :vartype endpoint: str
    :param input_schema: This determines the format that Event Grid should expect for incoming
     events published to the domain. Possible values include: "EventGridSchema",
     "CustomEventSchema", "CloudEventSchemaV1_0".
    :type input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :param input_schema_mapping: Information about the InputSchemaMapping which specified the info
     about mapping event payload.
    :type input_schema_mapping: ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the domain.
    :vartype metric_resource_id: str
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'metric_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'input_schema': {'key': 'properties.inputSchema', 'type': 'str'},
        'input_schema_mapping': {'key': 'properties.inputSchemaMapping', 'type': 'InputSchemaMapping'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Domain, self).__init__(**kwargs)
        self.private_endpoint_connections = kwargs.get('private_endpoint_connections', None)
        self.provisioning_state = None
        self.endpoint = None
        self.input_schema = kwargs.get('input_schema', None)
        self.input_schema_mapping = kwargs.get('input_schema_mapping', None)
        self.metric_resource_id = None
        self.public_network_access = kwargs.get('public_network_access', None)
        self.inbound_ip_rules = kwargs.get('inbound_ip_rules', None)


class DomainRegenerateKeyRequest(msrest.serialization.Model):
    """Domain regenerate share access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate key1 or key2.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = kwargs['key_name']


class DomainSharedAccessKeys(msrest.serialization.Model):
    """Shared access keys of the Domain.

    :param key1: Shared access key1 for the domain.
    :type key1: str
    :param key2: Shared access key2 for the domain.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = kwargs.get('key1', None)
        self.key2 = kwargs.get('key2', None)


class DomainsListResult(msrest.serialization.Model):
    """Result of the List Domains operation.

    :param value: A collection of Domains.
    :type value: list[~azure.mgmt.eventgrid.models.Domain]
    :param next_link: A link for the next page of domains.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Domain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class DomainTopic(Resource):
    """Domain Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param provisioning_state: Provisioning state of the domain topic. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :type provisioning_state: str or ~azure.mgmt.eventgrid.models.DomainTopicProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainTopic, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class DomainTopicsListResult(msrest.serialization.Model):
    """Result of the List Domain Topics operation.

    :param value: A collection of Domain Topics.
    :type value: list[~azure.mgmt.eventgrid.models.DomainTopic]
    :param next_link: A link for the next page of domain topics.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DomainTopic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainTopicsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class DomainUpdateParameters(msrest.serialization.Model):
    """Properties of the Domain update.

    :param tags: A set of tags. Tags of the domains resource.
    :type tags: dict[str, str]
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainUpdateParameterProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.inbound_ip_rules = kwargs.get('inbound_ip_rules', None)


class EventHubEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the event hub destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of an Event Hub
     destination of an event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'EventHub'  # type: str
        self.resource_id = kwargs.get('resource_id', None)


class EventSubscription(Resource):
    """Event Subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar topic: Name of the topic of the event subscription.
    :vartype topic: str
    :ivar provisioning_state: Provisioning state of the event subscription. Possible values
     include: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed",
     "AwaitingManualAction".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.EventSubscriptionProvisioningState
    :param destination: Information about the destination where events have to be delivered for the
     event subscription.
    :type destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :param filter: Information about the filter for the event subscription.
    :type filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :param labels: List of user defined labels.
    :type labels: list[str]
    :param expiration_time_utc: Expiration time of the event subscription.
    :type expiration_time_utc: ~datetime.datetime
    :param event_delivery_schema: The event delivery schema for the event subscription. Possible
     values include: "EventGridSchema", "CustomInputSchema", "CloudEventSchemaV1_0".
    :type event_delivery_schema: str or ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :param retry_policy: The retry policy for events. This can be used to configure maximum number
     of delivery attempts and time to live for events.
    :type retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :param dead_letter_destination: The DeadLetter destination of the event subscription.
    :type dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'topic': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'topic': {'key': 'properties.topic', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'destination': {'key': 'properties.destination', 'type': 'EventSubscriptionDestination'},
        'filter': {'key': 'properties.filter', 'type': 'EventSubscriptionFilter'},
        'labels': {'key': 'properties.labels', 'type': '[str]'},
        'expiration_time_utc': {'key': 'properties.expirationTimeUtc', 'type': 'iso-8601'},
        'event_delivery_schema': {'key': 'properties.eventDeliverySchema', 'type': 'str'},
        'retry_policy': {'key': 'properties.retryPolicy', 'type': 'RetryPolicy'},
        'dead_letter_destination': {'key': 'properties.deadLetterDestination', 'type': 'DeadLetterDestination'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventSubscription, self).__init__(**kwargs)
        self.topic = None
        self.provisioning_state = None
        self.destination = kwargs.get('destination', None)
        self.filter = kwargs.get('filter', None)
        self.labels = kwargs.get('labels', None)
        self.expiration_time_utc = kwargs.get('expiration_time_utc', None)
        self.event_delivery_schema = kwargs.get('event_delivery_schema', None)
        self.retry_policy = kwargs.get('retry_policy', None)
        self.dead_letter_destination = kwargs.get('dead_letter_destination', None)


class EventSubscriptionFilter(msrest.serialization.Model):
    """Filter for the Event Subscription.

    :param subject_begins_with: An optional string to filter events for an event subscription based
     on a resource path prefix.
     The format of this depends on the publisher of the events.
     Wildcard characters are not supported in this path.
    :type subject_begins_with: str
    :param subject_ends_with: An optional string to filter events for an event subscription based
     on a resource path suffix.
     Wildcard characters are not supported in this path.
    :type subject_ends_with: str
    :param included_event_types: A list of applicable event types that need to be part of the event
     subscription. If it is desired to subscribe to all default event types, set the
     IncludedEventTypes to null.
    :type included_event_types: list[str]
    :param is_subject_case_sensitive: Specifies if the SubjectBeginsWith and SubjectEndsWith
     properties of the filter
     should be compared in a case sensitive manner.
    :type is_subject_case_sensitive: bool
    :param advanced_filters: An array of advanced filters that are used for filtering event
     subscriptions.
    :type advanced_filters: list[~azure.mgmt.eventgrid.models.AdvancedFilter]
    """

    _attribute_map = {
        'subject_begins_with': {'key': 'subjectBeginsWith', 'type': 'str'},
        'subject_ends_with': {'key': 'subjectEndsWith', 'type': 'str'},
        'included_event_types': {'key': 'includedEventTypes', 'type': '[str]'},
        'is_subject_case_sensitive': {'key': 'isSubjectCaseSensitive', 'type': 'bool'},
        'advanced_filters': {'key': 'advancedFilters', 'type': '[AdvancedFilter]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventSubscriptionFilter, self).__init__(**kwargs)
        self.subject_begins_with = kwargs.get('subject_begins_with', None)
        self.subject_ends_with = kwargs.get('subject_ends_with', None)
        self.included_event_types = kwargs.get('included_event_types', None)
        self.is_subject_case_sensitive = kwargs.get('is_subject_case_sensitive', False)
        self.advanced_filters = kwargs.get('advanced_filters', None)


class EventSubscriptionFullUrl(msrest.serialization.Model):
    """Full endpoint url of an event subscription.

    :param endpoint_url: The URL that represents the endpoint of the destination of an event
     subscription.
    :type endpoint_url: str
    """

    _attribute_map = {
        'endpoint_url': {'key': 'endpointUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventSubscriptionFullUrl, self).__init__(**kwargs)
        self.endpoint_url = kwargs.get('endpoint_url', None)


class EventSubscriptionsListResult(msrest.serialization.Model):
    """Result of the List EventSubscriptions operation.

    :param value: A collection of EventSubscriptions.
    :type value: list[~azure.mgmt.eventgrid.models.EventSubscription]
    :param next_link: A link for the next page of event subscriptions.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventSubscription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventSubscriptionsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class EventSubscriptionUpdateParameters(msrest.serialization.Model):
    """Properties of the Event Subscription update.

    :param destination: Information about the destination where events have to be delivered for the
     event subscription.
    :type destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :param filter: Information about the filter for the event subscription.
    :type filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :param labels: List of user defined labels.
    :type labels: list[str]
    :param expiration_time_utc: Information about the expiration time for the event subscription.
    :type expiration_time_utc: ~datetime.datetime
    :param event_delivery_schema: The event delivery schema for the event subscription. Possible
     values include: "EventGridSchema", "CustomInputSchema", "CloudEventSchemaV1_0".
    :type event_delivery_schema: str or ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :param retry_policy: The retry policy for events. This can be used to configure maximum number
     of delivery attempts and time to live for events.
    :type retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :param dead_letter_destination: The DeadLetter destination of the event subscription.
    :type dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
    """

    _attribute_map = {
        'destination': {'key': 'destination', 'type': 'EventSubscriptionDestination'},
        'filter': {'key': 'filter', 'type': 'EventSubscriptionFilter'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'expiration_time_utc': {'key': 'expirationTimeUtc', 'type': 'iso-8601'},
        'event_delivery_schema': {'key': 'eventDeliverySchema', 'type': 'str'},
        'retry_policy': {'key': 'retryPolicy', 'type': 'RetryPolicy'},
        'dead_letter_destination': {'key': 'deadLetterDestination', 'type': 'DeadLetterDestination'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventSubscriptionUpdateParameters, self).__init__(**kwargs)
        self.destination = kwargs.get('destination', None)
        self.filter = kwargs.get('filter', None)
        self.labels = kwargs.get('labels', None)
        self.expiration_time_utc = kwargs.get('expiration_time_utc', None)
        self.event_delivery_schema = kwargs.get('event_delivery_schema', None)
        self.retry_policy = kwargs.get('retry_policy', None)
        self.dead_letter_destination = kwargs.get('dead_letter_destination', None)


class EventType(Resource):
    """Event Type for a subject under a topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param display_name: Display name of the event type.
    :type display_name: str
    :param description: Description of the event type.
    :type description: str
    :param schema_url: Url of the schema for this event type.
    :type schema_url: str
    :param is_in_default_set: IsInDefaultSet flag of the event type.
    :type is_in_default_set: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'schema_url': {'key': 'properties.schemaUrl', 'type': 'str'},
        'is_in_default_set': {'key': 'properties.isInDefaultSet', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventType, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.schema_url = kwargs.get('schema_url', None)
        self.is_in_default_set = kwargs.get('is_in_default_set', None)


class EventTypesListResult(msrest.serialization.Model):
    """Result of the List Event Types operation.

    :param value: A collection of event types.
    :type value: list[~azure.mgmt.eventgrid.models.EventType]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventType]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventTypesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class HybridConnectionEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the HybridConnection destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource ID of an hybrid connection that is the destination of an
     event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnectionEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'HybridConnection'  # type: str
        self.resource_id = kwargs.get('resource_id', None)


class InboundIpRule(msrest.serialization.Model):
    """InboundIpRule.

    :param ip_mask: IP Address in CIDR notation e.g., 10.0.0.0/8.
    :type ip_mask: str
    :param action: Action to perform based on the match or no match of the IpMask. Possible values
     include: "Allow".
    :type action: str or ~azure.mgmt.eventgrid.models.IpActionType
    """

    _attribute_map = {
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InboundIpRule, self).__init__(**kwargs)
        self.ip_mask = kwargs.get('ip_mask', None)
        self.action = kwargs.get('action', None)


class InputSchemaMapping(msrest.serialization.Model):
    """By default, Event Grid expects events to be in the Event Grid event schema. Specifying an input schema mapping enables publishing to Event Grid using a custom input schema. Currently, the only supported type of InputSchemaMapping is 'JsonInputSchemaMapping'.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JsonInputSchemaMapping.

    All required parameters must be populated in order to send to Azure.

    :param input_schema_mapping_type: Required. Type of the custom mapping.Constant filled by
     server.  Possible values include: "Json".
    :type input_schema_mapping_type: str or ~azure.mgmt.eventgrid.models.InputSchemaMappingType
    """

    _validation = {
        'input_schema_mapping_type': {'required': True},
    }

    _attribute_map = {
        'input_schema_mapping_type': {'key': 'inputSchemaMappingType', 'type': 'str'},
    }

    _subtype_map = {
        'input_schema_mapping_type': {'Json': 'JsonInputSchemaMapping'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InputSchemaMapping, self).__init__(**kwargs)
        self.input_schema_mapping_type = None  # type: Optional[str]


class JsonField(msrest.serialization.Model):
    """This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime' properties. This represents a field in the input event schema.

    :param source_field: Name of a field in the input event schema that's to be used as the source
     of a mapping.
    :type source_field: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JsonField, self).__init__(**kwargs)
        self.source_field = kwargs.get('source_field', None)


class JsonFieldWithDefault(msrest.serialization.Model):
    """This is used to express the source of an input schema mapping for a single target field
in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
'eventtype' and 'dataversion' properties. This represents a field in the input event schema
along with a default value to be used, and at least one of these two properties should be provided.

    :param source_field: Name of a field in the input event schema that's to be used as the source
     of a mapping.
    :type source_field: str
    :param default_value: The default value to be used for mapping when a SourceField is not
     provided or if there's no property with the specified name in the published JSON event payload.
    :type default_value: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JsonFieldWithDefault, self).__init__(**kwargs)
        self.source_field = kwargs.get('source_field', None)
        self.default_value = kwargs.get('default_value', None)


class JsonInputSchemaMapping(InputSchemaMapping):
    """This enables publishing to Event Grid using a custom input schema. This can be used to map properties from a custom input JSON schema to the Event Grid event schema.

    All required parameters must be populated in order to send to Azure.

    :param input_schema_mapping_type: Required. Type of the custom mapping.Constant filled by
     server.  Possible values include: "Json".
    :type input_schema_mapping_type: str or ~azure.mgmt.eventgrid.models.InputSchemaMappingType
    :param id: The mapping information for the Id property of the Event Grid Event.
    :type id: ~azure.mgmt.eventgrid.models.JsonField
    :param topic: The mapping information for the Topic property of the Event Grid Event.
    :type topic: ~azure.mgmt.eventgrid.models.JsonField
    :param event_time: The mapping information for the EventTime property of the Event Grid Event.
    :type event_time: ~azure.mgmt.eventgrid.models.JsonField
    :param event_type: The mapping information for the EventType property of the Event Grid Event.
    :type event_type: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :param subject: The mapping information for the Subject property of the Event Grid Event.
    :type subject: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :param data_version: The mapping information for the DataVersion property of the Event Grid
     Event.
    :type data_version: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    """

    _validation = {
        'input_schema_mapping_type': {'required': True},
    }

    _attribute_map = {
        'input_schema_mapping_type': {'key': 'inputSchemaMappingType', 'type': 'str'},
        'id': {'key': 'properties.id', 'type': 'JsonField'},
        'topic': {'key': 'properties.topic', 'type': 'JsonField'},
        'event_time': {'key': 'properties.eventTime', 'type': 'JsonField'},
        'event_type': {'key': 'properties.eventType', 'type': 'JsonFieldWithDefault'},
        'subject': {'key': 'properties.subject', 'type': 'JsonFieldWithDefault'},
        'data_version': {'key': 'properties.dataVersion', 'type': 'JsonFieldWithDefault'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JsonInputSchemaMapping, self).__init__(**kwargs)
        self.input_schema_mapping_type = 'Json'  # type: str
        self.id = kwargs.get('id', None)
        self.topic = kwargs.get('topic', None)
        self.event_time = kwargs.get('event_time', None)
        self.event_type = kwargs.get('event_type', None)
        self.subject = kwargs.get('subject', None)
        self.data_version = kwargs.get('data_version', None)


class NumberGreaterThanAdvancedFilter(AdvancedFilter):
    """NumberGreaterThan Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NumberGreaterThanAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'NumberGreaterThan'  # type: str
        self.value = kwargs.get('value', None)


class NumberGreaterThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberGreaterThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NumberGreaterThanOrEqualsAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'NumberGreaterThanOrEquals'  # type: str
        self.value = kwargs.get('value', None)


class NumberInAdvancedFilter(AdvancedFilter):
    """NumberIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[float]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NumberInAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'NumberIn'  # type: str
        self.values = kwargs.get('values', None)


class NumberLessThanAdvancedFilter(AdvancedFilter):
    """NumberLessThan Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NumberLessThanAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'NumberLessThan'  # type: str
        self.value = kwargs.get('value', None)


class NumberLessThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberLessThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NumberLessThanOrEqualsAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'NumberLessThanOrEquals'  # type: str
        self.value = kwargs.get('value', None)


class NumberNotInAdvancedFilter(AdvancedFilter):
    """NumberNotIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[float]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NumberNotInAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'NumberNotIn'  # type: str
        self.values = kwargs.get('values', None)


class Operation(msrest.serialization.Model):
    """Represents an operation returned by the GetOperations request.

    :param name: Name of the operation.
    :type name: str
    :param display: Display name of the operation.
    :type display: ~azure.mgmt.eventgrid.models.OperationInfo
    :param origin: Origin of the operation.
    :type origin: str
    :param properties: Properties of the operation.
    :type properties: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationInfo'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class OperationInfo(msrest.serialization.Model):
    """Information about an operation.

    :param provider: Name of the provider.
    :type provider: str
    :param resource: Name of the resource type.
    :type resource: str
    :param operation: Name of the operation.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationInfo, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationsListResult(msrest.serialization.Model):
    """Result of the List Operations operation.

    :param value: A collection of operations.
    :type value: list[~azure.mgmt.eventgrid.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateEndpoint(msrest.serialization.Model):
    """PrivateEndpoint information.

    :param id: The ARM identifier for Private Endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class PrivateEndpointConnection(Resource):
    """PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param private_endpoint: The Private Endpoint resource for this Connection.
    :type private_endpoint: ~azure.mgmt.eventgrid.models.PrivateEndpoint
    :param group_ids: GroupIds from the private link service resource.
    :type group_ids: list[str]
    :param private_link_service_connection_state: Details about the state of the connection.
    :type private_link_service_connection_state: ~azure.mgmt.eventgrid.models.ConnectionState
    :param provisioning_state: Provisioning state of the Private Endpoint Connection. Possible
     values include: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :type provisioning_state: str or ~azure.mgmt.eventgrid.models.ResourceProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'group_ids': {'key': 'properties.groupIds', 'type': '[str]'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'ConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.group_ids = kwargs.get('group_ids', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """Result of the list of all private endpoint connections operation.

    :param value: A collection of private endpoint connection resources.
    :type value: list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :param next_link: A link for the next page of private endpoint connection resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PrivateLinkResource(msrest.serialization.Model):
    """Information of the private link resource.

    :param id: Fully qualified identifier of the resource.
    :type id: str
    :param name: Name of the resource.
    :type name: str
    :param type: Type of the resource.
    :type type: str
    :param group_id:
    :type group_id: str
    :param display_name:
    :type display_name: str
    :param required_members:
    :type required_members: list[str]
    :param required_zone_names:
    :type required_zone_names: list[str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.group_id = kwargs.get('group_id', None)
        self.display_name = kwargs.get('display_name', None)
        self.required_members = kwargs.get('required_members', None)
        self.required_zone_names = kwargs.get('required_zone_names', None)


class PrivateLinkResourcesListResult(msrest.serialization.Model):
    """Result of the List private link resources operation.

    :param value: A collection of private link resources.
    :type value: list[~azure.mgmt.eventgrid.models.PrivateLinkResource]
    :param next_link: A link for the next page of private link resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourcesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RetryPolicy(msrest.serialization.Model):
    """Information about the retry policy for an event subscription.

    :param max_delivery_attempts: Maximum number of delivery retry attempts for events.
    :type max_delivery_attempts: int
    :param event_time_to_live_in_minutes: Time To Live (in minutes) for events.
    :type event_time_to_live_in_minutes: int
    """

    _attribute_map = {
        'max_delivery_attempts': {'key': 'maxDeliveryAttempts', 'type': 'int'},
        'event_time_to_live_in_minutes': {'key': 'eventTimeToLiveInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetryPolicy, self).__init__(**kwargs)
        self.max_delivery_attempts = kwargs.get('max_delivery_attempts', None)
        self.event_time_to_live_in_minutes = kwargs.get('event_time_to_live_in_minutes', None)


class ServiceBusQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the service bus destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of the Service Bus
     destination of an event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceBusQueueEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'ServiceBusQueue'  # type: str
        self.resource_id = kwargs.get('resource_id', None)


class ServiceBusTopicEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the service bus topic destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of the Service Bus Topic
     destination of an event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceBusTopicEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'ServiceBusTopic'  # type: str
        self.resource_id = kwargs.get('resource_id', None)


class StorageBlobDeadLetterDestination(DeadLetterDestination):
    """Information about the storage blob based dead letter destination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the dead letter destination.Constant
     filled by server.  Possible values include: "StorageBlob".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.DeadLetterEndPointType
    :param resource_id: The Azure Resource ID of the storage account that is the destination of the
     deadletter events.
    :type resource_id: str
    :param blob_container_name: The name of the Storage blob container that is the destination of
     the deadletter events.
    :type blob_container_name: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'blob_container_name': {'key': 'properties.blobContainerName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageBlobDeadLetterDestination, self).__init__(**kwargs)
        self.endpoint_type = 'StorageBlob'  # type: str
        self.resource_id = kwargs.get('resource_id', None)
        self.blob_container_name = kwargs.get('blob_container_name', None)


class StorageQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the storage queue destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource ID of the storage account that contains the queue that
     is the destination of an event subscription.
    :type resource_id: str
    :param queue_name: The name of the Storage queue under a storage account that is the
     destination of an event subscription.
    :type queue_name: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'queue_name': {'key': 'properties.queueName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageQueueEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'StorageQueue'  # type: str
        self.resource_id = kwargs.get('resource_id', None)
        self.queue_name = kwargs.get('queue_name', None)


class StringBeginsWithAdvancedFilter(AdvancedFilter):
    """StringBeginsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StringBeginsWithAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'StringBeginsWith'  # type: str
        self.values = kwargs.get('values', None)


class StringContainsAdvancedFilter(AdvancedFilter):
    """StringContains Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StringContainsAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'StringContains'  # type: str
        self.values = kwargs.get('values', None)


class StringEndsWithAdvancedFilter(AdvancedFilter):
    """StringEndsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StringEndsWithAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'StringEndsWith'  # type: str
        self.values = kwargs.get('values', None)


class StringInAdvancedFilter(AdvancedFilter):
    """StringIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StringInAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'StringIn'  # type: str
        self.values = kwargs.get('values', None)


class StringNotInAdvancedFilter(AdvancedFilter):
    """StringNotIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StringNotInAdvancedFilter, self).__init__(**kwargs)
        self.operator_type = 'StringNotIn'  # type: str
        self.values = kwargs.get('values', None)


class Topic(TrackedResource):
    """EventGrid Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param private_endpoint_connections:
    :type private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the topic. Possible values include: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.TopicProvisioningState
    :ivar endpoint: Endpoint for the topic.
    :vartype endpoint: str
    :param input_schema: This determines the format that Event Grid should expect for incoming
     events published to the topic. Possible values include: "EventGridSchema", "CustomEventSchema",
     "CloudEventSchemaV1_0".
    :type input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :param input_schema_mapping: This enables publishing using custom event schemas. An
     InputSchemaMapping can be specified to map various properties of a source schema to various
     required properties of the EventGridEvent schema.
    :type input_schema_mapping: ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the topic.
    :vartype metric_resource_id: str
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'metric_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'input_schema': {'key': 'properties.inputSchema', 'type': 'str'},
        'input_schema_mapping': {'key': 'properties.inputSchemaMapping', 'type': 'InputSchemaMapping'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Topic, self).__init__(**kwargs)
        self.private_endpoint_connections = kwargs.get('private_endpoint_connections', None)
        self.provisioning_state = None
        self.endpoint = None
        self.input_schema = kwargs.get('input_schema', None)
        self.input_schema_mapping = kwargs.get('input_schema_mapping', None)
        self.metric_resource_id = None
        self.public_network_access = kwargs.get('public_network_access', None)
        self.inbound_ip_rules = kwargs.get('inbound_ip_rules', None)


class TopicRegenerateKeyRequest(msrest.serialization.Model):
    """Topic regenerate share access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate key1 or key2.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopicRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = kwargs['key_name']


class TopicSharedAccessKeys(msrest.serialization.Model):
    """Shared access keys of the Topic.

    :param key1: Shared access key1 for the topic.
    :type key1: str
    :param key2: Shared access key2 for the topic.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopicSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = kwargs.get('key1', None)
        self.key2 = kwargs.get('key2', None)


class TopicsListResult(msrest.serialization.Model):
    """Result of the List Topics operation.

    :param value: A collection of Topics.
    :type value: list[~azure.mgmt.eventgrid.models.Topic]
    :param next_link: A link for the next page of topics.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Topic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopicsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class TopicTypeInfo(Resource):
    """Properties of a topic type info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param provider: Namespace of the provider of the topic type.
    :type provider: str
    :param display_name: Display Name for the topic type.
    :type display_name: str
    :param description: Description of the topic type.
    :type description: str
    :param resource_region_type: Region type of the resource. Possible values include:
     "RegionalResource", "GlobalResource".
    :type resource_region_type: str or ~azure.mgmt.eventgrid.models.ResourceRegionType
    :param provisioning_state: Provisioning state of the topic type. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :type provisioning_state: str or ~azure.mgmt.eventgrid.models.TopicTypeProvisioningState
    :param supported_locations: List of locations supported by this topic type.
    :type supported_locations: list[str]
    :param source_resource_format: Source resource format.
    :type source_resource_format: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'resource_region_type': {'key': 'properties.resourceRegionType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'supported_locations': {'key': 'properties.supportedLocations', 'type': '[str]'},
        'source_resource_format': {'key': 'properties.sourceResourceFormat', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopicTypeInfo, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.resource_region_type = kwargs.get('resource_region_type', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.supported_locations = kwargs.get('supported_locations', None)
        self.source_resource_format = kwargs.get('source_resource_format', None)


class TopicTypesListResult(msrest.serialization.Model):
    """Result of the List Topic Types operation.

    :param value: A collection of topic types.
    :type value: list[~azure.mgmt.eventgrid.models.TopicTypeInfo]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopicTypeInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopicTypesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class TopicUpdateParameters(msrest.serialization.Model):
    """Properties of the Topic update.

    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicUpdateParameterProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopicUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.inbound_ip_rules = kwargs.get('inbound_ip_rules', None)


class WebHookEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the webhook destination for an event subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param endpoint_url: The URL that represents the endpoint of the destination of an event
     subscription.
    :type endpoint_url: str
    :ivar endpoint_base_url: The base URL that represents the endpoint of the destination of an
     event subscription.
    :vartype endpoint_base_url: str
    :param max_events_per_batch: Maximum number of events per batch.
    :type max_events_per_batch: int
    :param preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
    :type preferred_batch_size_in_kilobytes: int
    :param azure_active_directory_tenant_id: The Azure Active Directory Tenant ID to get the access
     token that will be included as the bearer token in delivery requests.
    :type azure_active_directory_tenant_id: str
    :param azure_active_directory_application_id_or_uri: The Azure Active Directory Application ID
     or URI to get the access token that will be included as the bearer token in delivery requests.
    :type azure_active_directory_application_id_or_uri: str
    """

    _validation = {
        'endpoint_type': {'required': True},
        'endpoint_base_url': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'endpoint_url': {'key': 'properties.endpointUrl', 'type': 'str'},
        'endpoint_base_url': {'key': 'properties.endpointBaseUrl', 'type': 'str'},
        'max_events_per_batch': {'key': 'properties.maxEventsPerBatch', 'type': 'int'},
        'preferred_batch_size_in_kilobytes': {'key': 'properties.preferredBatchSizeInKilobytes', 'type': 'int'},
        'azure_active_directory_tenant_id': {'key': 'properties.azureActiveDirectoryTenantId', 'type': 'str'},
        'azure_active_directory_application_id_or_uri': {'key': 'properties.azureActiveDirectoryApplicationIdOrUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebHookEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'WebHook'  # type: str
        self.endpoint_url = kwargs.get('endpoint_url', None)
        self.endpoint_base_url = None
        self.max_events_per_batch = kwargs.get('max_events_per_batch', None)
        self.preferred_batch_size_in_kilobytes = kwargs.get('preferred_batch_size_in_kilobytes', None)
        self.azure_active_directory_tenant_id = kwargs.get('azure_active_directory_tenant_id', None)
        self.azure_active_directory_application_id_or_uri = kwargs.get('azure_active_directory_application_id_or_uri', None)
