from __future__ import annotations

# TODO: These default values only represent what is filled in by JDFTx when a tag as a whole is missing.
# Subtags have different default values depending on other subtags of the same tag.
# One example is fluid-minimize, which has different convergence thresholds and max iterations depending
# on the algorithm specified. For these tags, a second set of default values which can map partially
# filled tagcontainers to the set as filled by JDFTx is needed.
default_inputs = {
    "basis": "kpoint-dependent",
    "coords-type": "Lattice",
    "core-overlap-check": "vector",
    "coulomb-interaction": "Periodic",
    "davidson-band-ratio": 1.1,
    "dump": [{"End": {"State": True}}],
    "dump-name": "$INPUT.$VAR",
    "elec-cutoff": 20.0,
    "elec-eigen-algo": "Davidson",
    "elec-ex-corr": "gga-PBE",
    "electronic-minimize": {
        "dirUpdateScheme": "FletcherReeves",
        "linminMethod": "DirUpdateRecommended",
        "nIterations": 100,
        "history": 15,
        "knormThreshold": 0,
        "maxThreshold": False,
        "energyDiffThreshold": 1e-08,
        "nEnergyDiff": 2,
        "convergeAll": False,
        "alphaTstart": 1,
        "alphaTmin": 1e-10,
        "updateTestStepSize": True,
        "alphaTreduceFactor": 0.1,
        "alphaTincreaseFactor": 3,
        "nAlphaAdjustMax": 3,
        "wolfeEnergy": 0.0001,
        "wolfeGradient": 0.9,
        "abortOnFailedStep": False,
        "fdTest": False,
    },
    "exchange-regularization": "WignerSeitzTruncated",
    "fluid": "None",
    "fluid-ex-corr": {
        "kinetic": "lda-TF",
        "exchange-correlation": "lda-PZ",
    },
    "fluid-gummel-loop": {"maxIterations": 10, "Atol": 1e-05},
    "fluid-minimize": {
        "dirUpdateScheme": "PolakRibiere",
        "linminMethod": "DirUpdateRecommended",
        "nIterations": 100,
        "history": 15,
        "knormThreshold": 0,
        "maxThreshold": False,
        "energyDiffThreshold": 0,
        "nEnergyDiff": 2,
        "convergeAll": False,
        "alphaTstart": 1,
        "alphaTmin": 1e-10,
        "updateTestStepSize": True,
        "alphaTreduceFactor": 0.1,
        "alphaTincreaseFactor": 3,
        "nAlphaAdjustMax": 3,
        "wolfeEnergy": 0.0001,
        "wolfeGradient": 0.9,
        "abortOnFailedStep": False,
        "fdTest": False,
    },
    "fluid-solvent": [
        {
            "name": "H2O",
            "concentration": 55.338,
            "functional": "ScalarEOS",
            "epsBulk": 78.4,
            "pMol": 0.92466,
            "epsInf": 1.77,
            "Pvap": 1.06736e-10,
            "sigmaBulk": 4.62e-05,
            "Rvdw": 2.61727,
            "Res": 1.42,
            "tauNuc": 343133.0,  # Dumped as an int but should be a float
            "poleEl": [
                {
                    "omega0": 15.0,
                    "gamma0": 7.0,
                    "A0": 1.0,
                },
            ],
        },
    ],
    "forces-output-coords": "Positions",
    "ion-width": 0.0,  # Dumped as an int but should be a float
    "ionic-minimize": {
        "dirUpdateScheme": "L-BFGS",
        "linminMethod": "DirUpdateRecommended",
        "nIterations": 0,
        "history": 15,
        "knormThreshold": 0.0001,
        "maxThreshold": False,
        "energyDiffThreshold": 1e-06,
        "nEnergyDiff": 2,
        "convergeAll": False,
        "alphaTstart": 1,
        "alphaTmin": 1e-10,
        "updateTestStepSize": True,
        "alphaTreduceFactor": 0.1,
        "alphaTincreaseFactor": 3,
        "nAlphaAdjustMax": 3,
        "wolfeEnergy": 0.0001,
        "wolfeGradient": 0.9,
        "abortOnFailedStep": False,
        "fdTest": False,
    },
    "kpoint": {
        "k0": 0.0,
        "k1": 0.0,
        "k2": 0.0,
        "weight": 1.0,
    },
    "kpoint-folding": {
        "n0": 1,
        "n1": 1,
        "n2": 1,
    },
    "latt-move-scale": {
        "s0": 1,
        "s1": 1,
        "s2": 1,
    },
    "latt-scale": {
        "s0": 1,
        "s1": 1,
        "s2": 1,
    },
    "lattice-minimize": {
        "dirUpdateScheme": "L-BFGS",
        "linminMethod": "DirUpdateRecommended",
        "nIterations": 0,
        "history": 15,
        "knormThreshold": 0,
        "maxThreshold": False,
        "energyDiffThreshold": 1e-06,
        "nEnergyDiff": 2,
        "convergeAll": False,
        "alphaTstart": 1,
        "alphaTmin": 1e-10,
        "updateTestStepSize": True,
        "alphaTreduceFactor": 0.1,
        "alphaTincreaseFactor": 3,
        "nAlphaAdjustMax": 3,
        "wolfeEnergy": 0.0001,
        "wolfeGradient": 0.9,
        "abortOnFailedStep": False,
        "fdTest": False,
    },
    "lcao-params": {
        "nIter": -1,
        "Ediff": 1e-06,
        "smearingWidth": 0.001,
    },
    "pcm-variant": "GLSSA13",
    "perturb-minimize": {
        "nIterations": 0,
        "algorithm": "MINRES",
        "residualTol": 0.0001,
        "residualDiffThreshold": 0.0001,
        "CGBypass": False,
        "recomputeResidual": False,
    },
    "spintype": "no-spin",
    "subspace-rotation-factor": {
        "factor": 1,
        "adjust": True,
    },
    "symmetries": "automatic",
    "symmetry-threshold": 0.0001,
}
