/*
 * Decompiled with CFR 0.152.
 */
package org.haskell.hslogger4j;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;

public class HsloggerLevel
extends Level {
    public static final int EMERGENCY_INT = 51000;
    public static final int ALERT_INT = 50000;
    public static final int CRITICAL_INT = 41000;
    public static final int ERROR_INT = 40000;
    public static final int WARNING_INT = 30000;
    public static final int NOTICE_INT = 21000;
    public static final int INFO_INT = 20000;
    public static final int DEBUG_INT = 10000;
    public static final HsloggerLevel EMERGENCY = new HsloggerLevel(51000, "EMERGENCY", 0);
    public static final HsloggerLevel ALERT = new HsloggerLevel(50000, "ALERT", 1);
    public static final HsloggerLevel CRITICAL = new HsloggerLevel(41000, "CRITICAL", 2);
    public static final HsloggerLevel ERROR = new HsloggerLevel(40000, "ERROR", 3);
    public static final HsloggerLevel WARNING = new HsloggerLevel(30000, "WARNING", 4);
    public static final HsloggerLevel NOTICE = new HsloggerLevel(21000, "NOTICE", 5);
    public static final HsloggerLevel INFO = new HsloggerLevel(20000, "INFO", 6);
    public static final HsloggerLevel DEBUG = new HsloggerLevel(10000, "DEBUG", 7);

    protected HsloggerLevel(int n, String string, int n2) {
        super(n, string, n2);
    }

    public static HsloggerLevel toLevel(int n, HsloggerLevel hsloggerLevel) {
        switch (n) {
            case 51000: {
                return EMERGENCY;
            }
            case 50000: {
                return ALERT;
            }
            case 41000: {
                return CRITICAL;
            }
            case 40000: {
                return ERROR;
            }
            case 30000: {
                return WARNING;
            }
            case 21000: {
                return NOTICE;
            }
            case 20000: {
                return INFO;
            }
            case 10000: {
                return DEBUG;
            }
        }
        return hsloggerLevel;
    }

    public static Level toLevel(int n) {
        return HsloggerLevel.toLevel(n, CRITICAL);
    }

    public static List getAllPossibleLevels() {
        ArrayList<HsloggerLevel> arrayList = new ArrayList<HsloggerLevel>();
        arrayList.add(DEBUG);
        arrayList.add(INFO);
        arrayList.add(NOTICE);
        arrayList.add(WARNING);
        arrayList.add(ERROR);
        arrayList.add(CRITICAL);
        arrayList.add(ALERT);
        arrayList.add(EMERGENCY);
        return arrayList;
    }

    public static Level toLevel(String string) {
        return HsloggerLevel.toLevel(string, Level.DEBUG);
    }

    public static Level toLevel(String string, Level level) {
        if (string == null) {
            return level;
        }
        String string2 = string.toUpperCase();
        if (string2.equals("EMERGENCY")) {
            return EMERGENCY;
        }
        if (string2.equals("ALERT")) {
            return ALERT;
        }
        if (string2.equals("CRITICAL")) {
            return CRITICAL;
        }
        if (string2.equals("ERROR")) {
            return ERROR;
        }
        if (string2.equals("WARNING")) {
            return WARNING;
        }
        if (string2.equals("NOTICE")) {
            return NOTICE;
        }
        if (string2.equals("INFO")) {
            return INFO;
        }
        if (string2.equals("DEBUG")) {
            return DEBUG;
        }
        return level;
    }
}

