
      program     he5_sw_writedimscaleF_32
! This code creates fields and with just one call to HE5_SWdefdimscale creates dimmension scales
! for all fields that share the same dimension (both geofoelds and datafields). You need to call
! he5_sw_setupF_32 only before calling the he5_sw_definefields_and_all_dimscalesF_32
      implicit    none

      include     'hdfeos5.inc'

      integer     status
      integer     i, j
      integer     he5_swopen
      integer     he5_swattach
      integer     he5_swsetfill
      integer     he5_swdefgfld
      integer     he5_prdefine
      integer     he5_swdefdfld
      integer     he5_swdefchunk
      integer     he5_swdefcomp
      integer     he5_swdetach
      integer     he5_swclose
      integer     he5_szip_can_encode
      integer     HE5_SWsetdimscale
      integer     HE5_SWwritedscaleattr
      integer     HE5_SWdefdimscale

      integer     swfid,swid1
      integer*4   datbuf_i1
      integer*4   datbuf_i(15)
      integer*4   count(2)
      integer*4   nbands
      integer     bands(3)
      integer*4   datbuf_i2(3)
      integer     xdim, ydim, ntime
      integer     data(15)
      integer     data2(20)
      integer     FAIL
      parameter   (FAIL=-1)
      integer     nscanline
      real*8      fillval1
      integer     fillval2
      integer     chunkrank
      integer     canenc
      integer*4   chunkdims(3)
      integer*4   chunk_dims(3)
      integer     compparm(1)
      integer     comp_code 
      integer     comp_level(1)

      fillval1 = -1.11111    
      fillval1 = -9999
   

      do i=1,15
         data(i) = i*2-1
      enddo
      do i=1,20
         data2(i) = i*3-1
      enddo

      swfid = HE5_SWopen("swath.he5", HE5F_ACC_RDWR)
      write(*,*) 'File ID returned by he5_swopen(): ',swfid
!  /*
!   * If the swath file cannot be found, HE5_SWopen will return -1 for the file
!   * handle (swfid).  We there check that this is not the case before
!   * proceeding with the other routines.
!   * 
!   * The HE5_SWattach routine returns the handle to the existing swath "Swath1",
!   * SWid.  If the swath is not found, HE5_SWattach returns -1 for the handle.
!   */ 

      if (swfid .ne. FAIL) then
 
         SWid1 = HE5_SWattach(swfid, "Swath1")
         write(*,*) 'Swath ID returned by he5_swattach(): ',swid1

!      /* the field Spectra has Bands,Res2tr,Res2xtr dimensions. 
!	 xdim = 120
!	 ydim = 200
!	 Time dim is set to 10
!      */

         if (SWid1 .eq. -1) then
            
            write(*,*) 'Error: Cannot attach to swath Swath1. Stpped.'
            status = HE5_SWclose(swfid)
            stop
            
         endif

!	  /*
!	   * We define seven fields.  The first three, "Time", "Longitude"
!	   * and "Latitude" are geolocation fields and thus we use the
!	   * geolocation dimensions "GeoTrack" and "GeoXtrack" in the field
!	   * definitions.
!	   * 
!	   * The next four fields are data fields.  Note that either
!	   * geolocation or data dimensions can be used.
!	   */
	  
        status = he5_swsetfill(SWid1,"Time",HE5T_NATIVE_DOUBLE,
     1    fillval1)
	write(*,*) 'Status returned by HE5_SWsetfillvalue',
     1   '(...,Time,...) :    ', status
	  
        status = he5_swdefgfld(SWid1, "Time", "GeoTrack", 
     1     " ", HE5T_NATIVE_DOUBLE, 0)
	write(*,*) 'Status returned by HE5_SWdefgeofield',
     1   '(...,Time,...) :    ', status
	  
	status = he5_swdefgfld(SWid1, "Longitude", 
     1     "GeoTrack,GeoXtrack", " ", HE5T_NATIVE_FLOAT, 0)
	write(*,*) 'Status returned by HE5_SWdefgeofield',
     1   '(...,Longitude,...) :    ', status
	  
	status = he5_swdefgfld(SWid1, "Latitude", 
     1     "GeoTrack,GeoXtrack", " ", HE5T_NATIVE_FLOAT, 0)
	write(*,*) 'Status returned by HE5_SWdefgeofield',
     1   '(...,Latitude,...) :    ', status
        status = he5_swsetfill(SWid1,"Test_string",HE5T_NATIVE_CHAR,
     1           'missing')	  
	write(*,*) 'Status returned by HE5_SWsetfillvalue',
     1   '(...,Test_string,...) :    ', status
	  
	status = he5_swdefdfld(SWid1, "Test_string", "GeoXtrack", 
     1     " ", HE5T_CHARSTRING, 0)
	write(*,*) 'Status returned by HE5_SWdefdatafield',
     1   '(...,Test_string,...) :    ', status
	  
	status = he5_swsetfill(SWid1,"Density",
     1     HE5T_NATIVE_INT, fillval2)
	write(*,*) 'Status returned by HE5_SWsetfillvalue',
     1   '(...,Density,...) :    ', status
	  
	status = he5_swdefdfld(SWid1, "Density", "GeoTrack", 
     1     " ", HE5T_NATIVE_INT, 0)
	write(*,*) 'Status returned by HE5_SWdefdatafield',
     1   '(...Density,...) :    ', status
	  
	status = he5_swdefdfld(SWid1, "Temperature", 
     1      "GeoTrack,GeoXtrack", " ", HE5T_NATIVE_FLOAT, 0)
     	write(*,*) 'Status returned by HE5_SWdefdatafield',
     1   '(...Temperature,...) :    ', status

	chunkrank = 1
	comp_level(1) =0	  
	chunk_dims(1) = 40
	  
	status = he5_swdefchunk(SWid1, chunkrank, chunk_dims)
	write(*,*) 'Status returned by HE5_SWdefchunk() :    ',
     1   status
	  
	status = HE5_SWdefcomp(SWid1,HE5_HDFE_COMP_NONE,comp_level)
	status = he5_swdefdfld(SWid1, "Pressure", "Res2tr", " ", 
     1    HE5T_NATIVE_FLOAT, 0)
	write(*,*) '"Status returned by HE5_SWdefdatafield',
     1   '(...,Pressure,...):    ',status
	  
c	  /* Define Appendable Field */
c	  /* ----------------------- */
c	  
c	  /*           First, define chunking          */
c	  /* (the appendable dataset must be chunked)  */
c	  /* ----------------------------------------  */

        chunkrank = 3
        chunk_dims(1) = 20
        chunk_dims(2) = 40
        chunk_dims(3) = 15
        compparm(1) = 6
        
        status = HE5_SWdefchunk(SWid1, chunkrank, chunk_dims)
        write(*,*) 'Status returned by HE5_SWdefchunk() :    ',
     1       status
	  
c	  /* Second, define compression scheme */
c	  /* --------------------------------- */ 
c	  
c	  /* set the value of compression code: */
c	  /*  HDFE_COMP_NONE                  0 */
c	  /*  HDFE_COMP_RLE                   1 */   
c	  /*  HDFE_COMP_NBIT                  2 */   
c	  /*  HDFE_COMP_SKPHUFF               3 */   
c	  /*  HDFE_COMP_DEFLATE               4 */           
c	  /*  HDFE_COMP_SZIP_CHIP             5 */
c	  /*  HDFE_COMP_SZIP_K13              6 */
c	  /*  HDFE_COMP_SZIP_EC               7 */
c	  /*  HDFE_COMP_SZIP_NN               8 */
c	  /*  HDFE_COMP_SZIP_K13orEC          9 */
c	  /*  HDFE_COMP_SZIP_K13orNN          10 */
c	  /*  HDFE_COMP_SHUF_DEFLATE          11 */
c	  /*  HDFE_COMP_SHUF_SZIP_CHIP        12 */
c	  /*  HDFE_COMP_SHUF_SZIP_K13         13 */
c	  /*  HDFE_COMP_SHUF_SZIP_EC          14 */
c	  /*  HDFE_COMP_SHUF_SZIP_NN          15 */
c	  /*  HDFE_COMP_SHUF_SZIP_K13orEC     16 */
c	  /*  HDFE_COMP_SHUF_SZIP_K13orNN     17 */
	  
        comp_code = 16
        
        canenc = he5_szip_can_encode()
        if (canenc .ne. 0) then	  
           status = HE5_SWdefcomp(SWid1,
     1          HE5_HDFE_COMP_SHUF_SZIP_K13orEC,compparm)
           write(*,*) 'Status returned by he5_swdefcomp():  ',
     1          status
        else
           write(*,*) 'SZIP encoder is not available.'
           write(*,*) 'The data compression test is skipped.'
        endif
        
        
        status = he5_swdefdfld(SWid1, "Spectra", 
     1       "Res2xtr,Res2tr,Bands", " ", HE5T_NATIVE_FLOAT, 0)
c     status = he5_swdefdfld(SWid1, "Spectra", 
c     1           "Bands,Res2tr,Res2xtr", " ", HE5T_NATIVE_FLOAT, 0)
        write(*,*) '"Status returned by HE5_SWdefdatafield',
     1       '(...,Spectra,...) :    ',status
	  
c     Define Profile Field
c     -----------------------  
        status = he5_prdefine(SWid1, "Profile-2000", 
     1       "ProfDim", " ", HE5T_NATIVE_INT)
        write(*,*) 'Status returned by he5_prdefine():  ',status
        
        chunk_dims(1) = 20
        chunkrank = 1

        status = HE5_SWdefchunk(SWid1, chunkrank, chunk_dims)
        write(*,*) 'Status returned by HE5_SWdefchunk() :   ',status
        
c     Define Appendable Field
c     -----------------------  
        status = he5_swdefdfld(SWid1, "Count", "GeoTrack",
     1       "Unlim", HE5T_NATIVE_INT, 0)	      
        
      endif
      
      
c     Detach from the swath
c     ---------------------      
      status = he5_swdetach(SWid1)
      write(*,*) 'Status returned by he5_swdetach():  ',status 
      
c     Close the file
c     --------------      
      status = he5_swclose(swfid)
      write(*,*) 'Status returned by he5_swclose():  ',status  

      swfid = HE5_SWopen("swath.he5", HE5F_ACC_RDWR)
      SWid1 = HE5_SWattach(swfid, "Swath1")


      if (SWid1 .NE. FAIL) then
c     /*define one call dimscale setup for "GeoTrack" in all fields in Swath1 */
         nscanline = 20
         status = HE5_SWdefdimscale2(SWid1, "GeoTrack", "geotrack",
     1		nscanline, HE5T_NATIVE_INT, data2)
         if (status .EQ. -1) then
            write(*,*) 'Error: Cannot define Dimension Scale',
     1           ' for GeoTrack  dimemnsion '
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         else
            write(*,*) 'Status returned by HE5_SWdefdimscale(): ',
     1          'GeoTrack: ', status
            
         endif

         count(1)= 12
         status = HE5_SWwritedscaleattr(SWid1, "GeoTrack", "label", 
     1        HE5T_NATIVE_CHAR, count, "GeoTrack Dim")
         if (status .EQ.  -1) then
            write(*,*) 'Error: Cannot define Dimension Scale label',
     1           ' strs for GeoTrack dimemnsion'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         else
            write(*,*) 'Status returned by ',
     1           'HE5_SWwritedscaleattr(): label: ',status
         endif

c	  /*define one call dimscale setup for "Bnds" in all fields in Swath1 */
	  nbands = 15
	  status = HE5_SWdefdimscale(SWid1, "Bands", 
     1         nbands, HE5T_NATIVE_INT, data)
	  if (status  .EQ.  -1) then
             write(*,*) 'Error: Cannot define Dimension Scale label',
     1           ' strs for Bands dimemnsion'
	      status = HE5_SWdetach(SWid1)
	      status = HE5_SWclose(swfid)
	      stop
           else
	      write(*,*) 'Status returned by HE5_SWdefdimscale():',
     1             'Bands: ',status
           endif

	  count(1)= 9
	  status = HE5_SWwritedscaleattr(SWid1, "Bands", "label", 
     1         HE5T_NATIVE_CHAR, count, "Bands Dim")
	  if (status  .EQ.  -1) then
             write(*,*) 'Error: Cannot define Dimension Scale label',
     1            ' strs for Bands dimemnsion'
             status = HE5_SWdetach(SWid1)
             status = HE5_SWclose(swfid)
	     stop
	  else
	      write(*,*) 'Status returned by HE5_SWwritedscaleattr():',
     1            'label: ' ,status
           endif

	  count(1) = 4
	  status = HE5_SWwritedscaleattr(SWid1, "Bands", "unit", 
     1         HE5T_NATIVE_CHAR, count, "None")
	  if (status  .EQ.  -1) then
	      write(*,*) '"Error: Cannot define Dimension Scale',
     1            ' unit strs for Bands dimemnsion'
	      status = HE5_SWdetach(SWid1)
	      status = HE5_SWclose(swfid)
	      STOP
	  else
	      write(*,*) 'Status returned by HE5_SWwritedscaleattr():',
     1            ' unit: ',status
           endif

	  count(1)= 2
	  status = HE5_SWwritedscaleattr(SWid1, "Bands", "format", 
     1         HE5T_NATIVE_CHAR, count, "I2")
	  if (status  .EQ.  -1) then
	      write(*,*) 'Error: Cannot define Dimension Scale',
     1           ' format strs for Bands dimemnsion'
	      status = HE5_SWdetach(SWid1)
	      status = HE5_SWclose(swfid)
	      stop
	  else
	      write(*,*) 'Status returned by HE5_SWwritedscaleattr(): ',
     1            'format: ',status
           endif

	  datbuf_i1 = -999
	  count(1) = 1

	  status = he5_swwritedscaleattr(SWid1, "Bands", "MissingValue", 
     1         HE5T_NATIVE_INT, count, datbuf_i1)
	  if (status  .EQ.  -1) then
	      write(*,*) 'Error: Cannot define Dimension Scale ',
     1            'MissingValue for Bands dimemnsion'
	      status = HE5_SWdetach(SWid1)
	      status = HE5_SWclose(swfid)
              stop
	  else
	      write(*,*) 'Status returned by HE5_SWwritedscaleattr(): ',
     1            'MissingValue: ',status
           endif

	  datbuf_i2(1) = -999
	  datbuf_i2(2) = 0
	  datbuf_i2(3) = 999
	  count(1) = 3

	  status = HE5_SWwritedscaleattr(SWid1, "Bands", "IntValues", 
     1         HE5T_NATIVE_INT, count, datbuf_i2)
	  if (status  .EQ.  -1) then
	      write(*,*) 'Error: Cannot define Dimension Scale',
     1            ' IntValues for Bands dimemnsion'
	      status = HE5_SWdetach(SWid1)
	      status = HE5_SWclose(swfid)
	      stop
	  else
	      write(*,*) 'Status returned by HE5_SWwritedscaleattr():',
     1            ' IntValues: ',status
           endif
	endif
       status = HE5_SWdetach(SWid1)
      status = HE5_SWclose(swfid)
  
      stop
      end PROGRAM


