// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __SysCall_h__
#define __SysCall_h__

// Helper functions that access system interfaces

#include <sys/stat.h>
#include <ctime>
#include <filesystem>

namespace SysCall {

  // get the UNIX modification time of a file
  // returns 'false' on any error, otherwise result will be set
  bool file_modification_time(const std::filesystem::path &file, std::time_t &result);

  // create the specified directory hierarchy; return false on error
  bool make_directory_hierarchy(const std::filesystem::path &dir);

#if defined (WIN32)
  // replace all '\' in a string (filename path) with '/'
  void make_unix_path(std::string &path);
#endif

  // build a canonical representation of a file path
  // - the resulting path is absolute and contains neither ".", "..", nor soft links
  // - on Windows all '\' are replace by '/'
  // returns 'false' on any error, e.g. file does not exist
  bool make_canonical_path(const std::filesystem::path &path, std::string &result);
}
#endif // __SysCall_h__
