# -*- coding: utf-8 -*-
# Copyright 2024 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the vyos_ospf_interfaces module
"""


class Ospf_interfacesArgs(object):  # pylint: disable=R0903
    """The arg spec for the vyos_ospf_interfaces module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str"},
                "address_family": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "afi": {
                            "type": "str",
                            "choices": ["ipv4", "ipv6"],
                            "required": True,
                        },
                        "authentication": {
                            "type": "dict",
                            "options": {
                                "plaintext_password": {
                                    "type": "str",
                                    "no_log": True,
                                },
                                "md5_key": {
                                    "type": "dict",
                                    "no_log": False,
                                    "options": {
                                        "key_id": {"type": "int"},
                                        "key": {"type": "str", "no_log": True},
                                    },
                                },
                            },
                        },
                        "bandwidth": {"type": "int"},
                        "cost": {"type": "int"},
                        "dead_interval": {"type": "int"},
                        "hello_interval": {"type": "int"},
                        "mtu_ignore": {"type": "bool"},
                        "network": {"type": "str"},
                        "priority": {"type": "int"},
                        "retransmit_interval": {"type": "int"},
                        "transmit_delay": {"type": "int"},
                        "ifmtu": {"type": "int"},
                        "instance": {"type": "str"},
                        "passive": {"type": "bool"},
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "parsed",
                "rendered",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
